/**
 Basic demonstration of using a joystick.
 
 Tested with Logitech Extreme 3D Pro
 When this sketch runs it will try and find
 a game device that matches the configuration
 file 'joystick' if it can't match this device
 then it will present you with a list of devices
 you might try and use.
 
 The chosen device requires 2 sliders and 2 buttons.
 
 for Processing V3
 (c) 2020 Peter Lager
 */

import org.gamecontrolplus.gui.*;
import org.gamecontrolplus.*;
import net.java.games.input.*;

ControlIO control;
ControlDevice stick;
float px, py;

public void setup() {
  size(400, 400);
  surface.setTitle("GCP Joystick example");
  // Initialise the ControlIO
  control = ControlIO.getInstance(this);
  // Find a joystick that matches the configuration file. To match with any 
  // connected device remove the call to filter.
  stick = control.filter(GCP.STICK).getMatchedDevice("joystick");
  if (stick == null) {
    println("No suitable device configured");
    System.exit(-1); // End the program NOW!
  }
}

// Poll for user input called from the draw() method.
public void getUserInput() {
  px = map(stick.getSlider("X").getValue(), -1, 1, 0, width);
  py = map(stick.getSlider("Y").getValue(), -1, 1, 0, height);

}

public void draw() {
  getUserInput(); // Polling the input device
  background(255, 255, 240);
  // Draw shadows
  fill(0, 0, 255, 32);
  noStroke();
  ellipse(px, py, 60, 60);
}
